'PCOS Kernel Hardware Module (hardmod.bas) version 2.0
'Copyright 1995-2008 by Mercury0x000D

'hardmod.bas is a part of the PCOS Kernel

'The PCOS Kernel is free software: you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation, either version 3 of the License, or
'(at your option) any later version.

'The PCOS Kernel is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'GNU General Public License for more details.

'You should have received a copy of the GNU General Public License
'along with the PCOS Kernel.  If not, see <http://www.gnu.org/licenses/>.

'See the included file <GPL License.txt> for the complete text of the 
'GPL License by which this program is covered.


'credits:
'The functions HMGetDriveType & HMGetDrives are modified versions of code
'from the freeware 'PB-DiskInfo 2.5' made in 1998 by Marc van den Dikkenberg

'The functions HMCDOpen and HMCDClose are modified versions of code from
'the freeware 'CDPLAY' v4.62 made in 1996 - 1997 by Toshi Horie.





defint a-z
sub HMMouseInit (mouseInstalled, copyrightStr$, driverMajorVer, driverMinorVer, mouseType$, wheelAvail, numButtons)
 xax?? = 0
 xbx?? = 0
 xbh?? = 0
 xbl?? = 0
 xcx?? = 0
 xch?? = 0
 xes?? = 0
 xdi?? = 0
 !mov ax, 00
 !int &h33
 !mov xax??, ax
 !mov xbx??, bx
 if xax?? = 0 then
  mouseInstalled = 0
  exit sub
 else
  mouseinstalled = 1
 end if
 select case xbx??
  case = 1, 3
   numButtons = xbx??
  case else
   numButtons = 2
 end select
 !mov ax, &h11
 !int &h33
 !mov xax??, ax
 !mov xcx??, cx
 if xax?? = &h574D and bit (xcx??, 0) = 1 then wheelAvail = 1 else wheelAvail = 0
 !mov ax, &h24
 !mov bx, 0
 !int &h33
 !mov xbh??, bh
 !mov xbl??, bl
 !mov xch??, ch
 driverMajorVer = xbh??
 driverMinorVer = xbl??
 select case xch??
  case = 1
   mouseType$ = "bus"
  case = 2
   mouseType$ = "serial"
  case = 3
   mouseType$ = "InPort"
  case = 4
   mouseType$ = "PS/2"
  case = 5
   mouseType$ = "HP"
  case = 6
   mouseType$ = "other"
 end select
 !mov ax, &h4D
 !int &h33
 !mov xes??, es
 !mov xdi??, di
 xDefSeg?? = pbvDefSeg
 if xDefSeg?? = 0 then system
 def seg = xes??
 a?? = xdi??
 b = 1
 do until b = 0
  b = peek(a??)
  if b >= 32 and b <= 126 and len(c$) < 128 then copyrightStr$ = copyrightStr$ + chr$(b)
  incr a??
  'this makes sure we only scan the first 128 bytes for a copyright string
  if xdi?? - a?? > 128 then b = 0
  'this limits the copyright string to avoid string too long errors
  if len(copyrightStr$) = 128 then b = 0
 loop
 def seg = xDefSeg??
end sub





sub HMMouseShow
 !mov ax, 1
 !int &h33
end sub





sub HMMouseHide
 !mov ax, 2
 !int &h33
end sub





defint a-z
sub HMMouseGetStatus (h, v, l, m, r, wheel)
 xbl?? = 0
 xbh?? = 0
 xcx?? = 0
 xdx?? = 0
 !mov ax, 3
 !int &h33
 !mov xbl??, bl
 !mov xbh??, bh
 !mov xcx??, cx
 !mov xdx??, dx
 h = xcx??
 v = xdx??
 l = bit(xbl??, 0)
 m = bit(xbl??, 2)
 r = bit(xbl??, 1)
 wheel = xbh??
end sub





defint a-z
sub HMMouseSetLocation (h, v)
 xcx?? = h
 xdx?? = v
 !mov ax, &h4
 !mov cx, xcx??
 !mov dx, xdx??
 !int &h33
end sub





defint a-z
sub HMMouseSetRange (hmin, vmin, hmax, vmax)
 xax?? = 0
 'set horizontal range
 if hmin < 0 then xcx?? = 0 else xcx?? = hmin
 xdx?? = hmax
 !mov ax, &h7
 !mov cx, xcx??
 !mov dx, xdx??
 !int &h33
 'set vertical range
 if vmin < 0 then xcx?? = 0 else xcx?? = vmin
 xdx?? = vmax
 !mov ax, &h8
 !mov cx, xcx??
 !mov dx, xdx??
 !int &h33
end sub





defint a-z
sub HMMouseSetSpeed (hSpeed, vSpeed, doubleSpeed)
 xbx?? = hSpeed
 xcx?? = vSpeed
 xdx?? = doubleSpeed
 !mov ax, &h1A
 !mov bx, xbx??
 !mov cx, xcx??
 !mov dx, xdx??
 !int &h33
end sub





defint a-z
sub HMMouseGetSpeed (hSpeed, vSpeed, doubleSpeed)
 xbx?? = 0
 xcx?? = 0
 xdx?? = 0
 !mov ax, &h1B
 !int &h33
 !mov xbx??, bx
 !mov xcx??, cx
 !mov xdx??, dx
 hSpeed = xbx??
 vSpeed = xcx??
 doubleSpeed = xdx??
end sub





defint a-z
sub HMBIOSGetDate (bd$)
 def seg = &hF000
 for a?? = 65525 to 65532
  bd$ = bd$ + chr$(peek(a??))
 next
end sub





defint a-z
sub HMGetMachineType (tc)
 def seg = &hF000
 tc = peek(65534)
end sub





defint a-z
sub HMNCPPresent (ncp)
 def seg = &h40
 a = peek(&h10)
 ncp = bit (a, 1)
end sub





SUB HMCDOpen (dr$)
 if dr$ = "" then exit sub
 drive = asc (ucase$(dr$)) - 65
 '0 = driver code to open the cd door
 control$ = CHR$(0)
 dim request(1 to 10) as word
 request(1) = 26
 request(2) = 12
 request(8) = strptr(control$)
 request(9) = strseg(control$)
 request(10) = 1
 aes?? = VARSEG(request(1))
 abx?? = VARPTR(request(1))
 !mov ax, &h1510
 !mov cx, drive
 !mov es, aes??
 !mov bx, abx??
 !int &h2F
END SUB





SUB HMCDClose (dr$)
 if dr$ = "" then exit sub
 drive = asc(ucase$(dr$)) - 65
 '5 = driver code to close the cd door
 control$ = CHR$(5)
 dim request(1 to 10) as word
 request(1) = 26
 request(2) = 12
 request(8) = strptr(control$)
 request(9) = strseg(control$)
 request(10) = 1
 aes?? = VARSEG(request(1))
 abx?? = VARPTR(request(1))
 !mov ax, &h1510
 !mov cx, drive
 !mov es, aes??
 !mov bx, abx??
 !int &h2F
END SUB





sub HMGetDrives (AllDrive$)
 var1$ = "    "
 var2$ = string$(255, 32)
 out &h70, &h10
 x = inp(&h71)
 if x \ 16 <> 0 then internal$ = internal$ + "A"
 if (x and &h0F) <> 0 then internal$ = internal$ + "B"
 for t = asc("C") to asc ("Z")
  var2$ = string$(255,0)
  driv$ = chr$(t)
  var1$ = driv$ + ":\" + chr$(0)
  ads?? = strseg(var1$)
  asi?? = strptr(var1$)
  aes?? = strseg(var2$)
  adi?? = strptr(var2$)
  !push ds
  !push si
  !push es
  !push di
  !mov ds, ads??
  !mov si, asi??
  !mov es, aes??
  !mov di, adi??
  !mov ax, &h6000
  !int &h21
  !pop di
  !pop es
  !pop si
  !pop ds
  if (reg(0) AND 1) = 1 then AllDrive$ = "":exit sub
  final$ = var2$
  final$ = rtrim$(final$, chr$(0))
  if final$ <> "" then internal$ = internal$ + left$(var1$, 1)
 next
 AllDrive$ = lcase$(internal$)
End sub





sub HMGetDriveType (DriveLetter$, td, extraStr1$, extraStr2$)
 '0 - not detected
 '1 - hard drive
 '2 - removable/USB drive
 '3 - network drive
 '4 - CD-ROM drive
 '5 - floppy drive
 '6 - mapped drive
 dim var1 as string*4
 dim var2 as string*255
 dim ads as word, asi as word, aes as word
 dim adi as word, dbx as word, dby as word
 ads = varseg(var1)
 asi = varptr(var1)
 aes = varseg(var2)
 adi = varptr(var2)
 CDBuff$ = string$(10, 0)
 extraStr1$ = ""
 extraStr2$ = ""
 Floppy.Measure = 0
 Floppy.Capacity = 0
 DriveLetter$ = ucase$(Left$(DriveLetter$, 1))
 if DriveLetter$ = "A" or DriveLetter$ = "B" then
  Out &H70, &H10
  x = Inp(&H71)
  if DriveLetter$ = "A" and x \ 16 <> 0 then
   td = 5
   Select Case x \ 16
    Case 1: extraStr1$ = "5.25":extraStr2$ = "360"
    case 2: extraStr1$ = "5.25":extraStr2$ = "1200"
    Case 3: extraStr1$ = "3.5":extraStr2$ = "720"
    Case 4: extraStr1$ = "3.5":extraStr2$ = "1440"
    Case 5: extraStr1$ = "3.5":extraStr2$ = "2880"
   End Select
   Exit sub
  elseif DriveLetter$ = "B" and (x AND &H0F) <> 0 then
   td = 5
   Select Case (x AND &H0F)
    Case 1: extraStr1$ = "5.25":extraStr2$ = "360"
    case 2: extraStr1$ = "5.25":extraStr2$ = "1200"
    Case 3: extraStr1$ = "3.5":extraStr2$ = "720"
    Case 4: extraStr1$ = "3.5":extraStr2$ = "1440"
    Case 5: extraStr1$ = "3.5":extraStr2$ = "2880"
   End Select
   Exit sub
  else
   td = 0
   Exit sub
  end if
 end if
 if left$(CDBuff$, 1) = chr$(0) then
  'Generate a list of the driveletters in use by CD-ROMs
  !mov AX, &HDADA
  !push AX
  !mov AX, &H01100
  !int &H2F
  !pop BX
  !cmp BX, &HADAD
  !jne mscdex_not_installed
  !cmp AL, &H0FF
  !jne mscdex_not_installed
  goto mscdex_version
  mscdex_not_installed:
  Exit sub
  mscdex_version:
  !MOV AX, &H150C
  !INT &H2F
  !MOV dbx, BX
  if (DBX \ 256) >= 2 THEN
   dim s1 as word
   dim o1 as word
   s1 = strseg(CDbuff$)
   o1 = strptr(CDbuff$)
   !MOV AX, &H150D
   !MOV ES, S1
   !MOV BX, O1
   !INT &H2F
  END IF
 end if
 var2 = string$(255, 0)
 var1 = DriveLetter$ + ":\" + chr$(0)
 ! MOV AX, &H6000
 ! MOV DS, ADS
 ! MOV SI, ASI
 ! MOV ES, AES
 ! MOV DI, ADI
 ! INT &H21
 if (reg(0) AND 1) = 1 then td = 7: Exit sub
 final$ = var2
 final$ = rtrim$(final$, chr$(0))
 if left$(final$, 1) = "\" then
  'Detected drive is a Network drive. This method only works outside Windows,
  'and with DOS < 7.0. The Windows / DOS 7+ Network check can be found below.
  on error goto TypeDriveErrorHandler
  ff = freefile
  open driveLetter$ + ":\cdtest" for output as #ff
  close #ff
  on local error resume next
  if flag = 1 then td = 4 else td = 3
  extraStr1$ = final$
  Exit sub
 end if
 if left$(var1, 1) = left$(final$, 1) then
  if instr(CDbuff$, chr$(asc(left$(final$, 1)) - 65)) then
   ' Drive is a CD-ROM
   td = 4: Exit sub
  else
   DRIV% = asc(left$(var1, 1)) - 64
   REG 1, &H4408
   REG 2, DRIV%
   CALL INTERRUPT &H21
   IF (REG(0) AND 1) = 1 then
    'Unknown - 'removable'-check not supported for this drive. Let's check if
    'it's a network drive! But first set TypeDrive to 7 (Unknown), just to be
    'sure.
    td = 7
    Reg 1, &H00
    Call Interrupt &H2A
    if (reg(1) \ 256) <> 0 then
     'NetBios detected. Now check for Network Drive + Path. This method works
     'in Windows / DOS 7.0+ too.
     ttt% = 0
     DevNam$ = string$(16, 0)
     NetPat$ = string$(128, 0)
     Do
      REG 1, &H5F02
      REG 2, ttt%
      REG 8, STRSEG(DevNam$)
      REG 5, STRPTR(DevNam$)
      REG 9, STRSEG(NetPat$)
      REG 6, STRPTR(NetPat$)
      CALL INTERRUPT &H21
      DevName$ = LEFT$(DevNam$, 1)
      incr ttt%, 1
      if ttt% = 26 then exit do
      if driveletter$ = left$(devnam$, 1) then
       ExtraStr1$ = RTRIM$(NetPat$, CHR$(0))
       td = 3:exit sub
      end if
     Loop
    end if
   else
    if reg(1) = 0 then
     ' Removable Disk
     td = 2:Exit sub
    else
     ' Fixed Disk
     td = 1:Exit sub
    end if
   end if
  end if
 elseif len(final$) <> 0 then
  ' mapped drive
  td = 6
  ExtraStr1$ = Final$
  Exit sub
 end if
 exit sub
TypeDriveErrorHandler:
 flag = 1
resume next
end sub